<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:ns1="http://www.mf.gov.pl/SENT/2017/12/08/SENT_400.xsd"
                xmlns:tp="http://www.mf.gov.pl/SENT/2017/12/08/STypes.xsd">
    <xsl:template match="ns1:SENT_400">
        <!-- TODO: Auto-generated template -->
        <html>
            <head>
              <script>
          //<![CDATA[
					// Module
				var languative;
				(function (languative) {
				    var phraseIdAttr = "data-phrase-id";

				    languative.ignoreTags = {
				        img: "<img />",
				        br: "<br />",
				        hr: "<hr />"
				    };

				    languative.dictonaries = {
				        html: {
				            _id: "en",
				            _name: "English"
				        },

				        pl: {
				            _id: "pl",
				            _name: "Polski - Polish"
				        },

				        en: {
				            _id: "en",
				            _name: "English"
				        }
				    };

				    languative.selectedDictionary = null;

				    function getDictionary(langKey) {
				        langKey = langKey.toLowerCase();
				        if (langKey in languative.dictonaries)
				            return languative.dictonaries[langKey];
				            else
				            return languative.dictonaries["pl"];

				        // Dictionary at key "pl-PL" not found, so keep looking for key "pl"
				        var sep = langKey.indexOf("-");
				        if (sep > 0)
				            langKey = langKey.substring(0, sep);
				        return languative.dictonaries[langKey];
				    }
				    languative.getDictionary = getDictionary;

				    function getPhrase(phraseId) {
				        var res = findPhrase(phraseId);
				        if (res)
				            return res; else
				            return phraseId;
				    }
				    languative.getPhrase = getPhrase;

				    function findPhrase(phraseId) {
				        if ((phraseId == null) || (phraseId == ""))
				            return null;

				        if ((languative.selectedDictionary != null) && (phraseId in languative.selectedDictionary))
				            return languative.selectedDictionary[phraseId];
				        if (phraseId in languative.dictonaries.html)
				            return languative.dictonaries.html[phraseId];

				        return null;
				    }
				    languative.findPhrase = findPhrase;

				    function getYesNo(value) {
				        if (value === undefined)
				            return getPhrase("undefined"); else if (value)
				            return getPhrase("yes"); else
				            return getPhrase("no");
				    }
				    languative.getYesNo = getYesNo;

				    //IE8 Tweak
				    function getAttr(node, attr) {
				        var result = (node.getAttribute && node.getAttribute(attr)) || null;
				        if (!result && node.attributes) {
				            for (var i = 0; i < node.attributes.length; i++) {
				                var attrNode = node.attributes[i];
				                if (attrNode.nodeName === attr)
				                    return attrNode.nodeValue;
				            }
				        }
				        return result;
				    }

				    function changeLanguage(langKey) {
				        function setTagPhrase(tag, phrase) {
				            if (tag.childNodes.length > 1) {
				                for (var ci = 0; ci < tag.childNodes.length; ci++) {
				                    var chNode = tag.childNodes[ci];
				                    var nName = chNode.nodeName.toLowerCase();
				                    if (!(nName in languative.ignoreTags)) {
				                        if ("innerHTML" in chNode) {
				                            chNode["innerHTML"] = " " + phrase[ci] + " ";
				                        } else {
				                            chNode.nodeValue = " " + phrase[ci] + " ";
				                        }
				                    }
				                }
				            } else {
				                tag.innerHTML = " " + phrase + " ";
				            }
				        }

				        //return;
				        var langDict = languative.getDictionary(langKey);
				        if (langDict == null) {
				            console.warn("Cannot identify dictionary by key '" + langKey + "'. Default dictionary (" + languative.dictonaries.html._id + ": " + languative.dictonaries.html._name + ") used instead.");
				            langDict = languative.dictonaries.html;
				        }
				        languative.selectedDictionary = langDict;

				        var tags = getHtmlTags();
				        for (var ti = 0; ti < tags.length; ti++) {
				            var tag = tags[ti];
				            var phraseId = getAttr(tag, phraseIdAttr);
				            if ((phraseId != null)) {
				                var phraseValue = languative.getPhrase(phraseId);
				                if (phraseValue) {
				                    setTagPhrase(tag, phraseValue);
				                } else {
				                    console.warn("Phrase not definied in dictionary: data-phrase-id='" + phraseId + "'");
				                }
				            }
				        }

				        if (langDict["Title"] != null) {
				            document.title = langDict["Title"];
				        }
				    }
				    languative.changeLanguage = changeLanguage;

				    function getHtmlTags() {
				        var res = new Array();
				        var docTags = document.body.getElementsByTagName("*");

				        for (var i = 0; i < docTags.length; i++) {
				            var docTag = docTags[i];
				            var phraseId = getAttr(docTag, phraseIdAttr);
				            if (phraseId)
				                res.push(docTag);
				        }
				        return res;
				    }

				    var initialized = false;

				    function init() {
				        if (!initialized) {
				            initialized = true;
				            var htmlDict = languative.dictonaries.en;

				            for (var dictKey in htmlDict) {
				                if (!(dictKey in languative.dictonaries.html)) {
				                    languative.dictonaries.html[dictKey] = htmlDict[dictKey];
				                }
				            }
				            var nav = window.navigator;
				            languative.changeLanguage(nav.userLanguage || nav.language);
				        }
				    }
				    languative.init = init;

				    function modifyDictionary(langKey, dictModifications) {
				        var langDict = languative.getDictionary(langKey);
				        if (langDict == null) {
				            languative.dictonaries[langKey.toLowerCase()] = dictModifications;
				        } else {
				            for (var dictKey in dictModifications) {
				                langDict[dictKey] = dictModifications[dictKey];
				            }
				        }
				    }
				    languative.modifyDictionary = modifyDictionary;
				})(languative || (languative = {}));

				if (document.addEventListener)
				    document.addEventListener('DOMContentLoaded', languative.init);

				if (window.addEventListener) {
				    window.addEventListener('load', languative.init, false);
				} else {
				    window.attachEvent('onload', languative.init);
				}
				<!-- sourceMappingURL=languative.js.map -->

				languative.modifyDictionary("html", {
            		githubLink: "Fork me on GitHub"
        		});
languative.modifyDictionary("pl", {
sent400: "SENT400 - WERYFIKACJA KLUCZY I POBRANIE ZGŁOSZENIA PRZEWOZU TOWARU",
selectLanguage: "Wybierz język:",
english: "English",
polish: "Polski",
sentNumber: "NUMER REFERENCYJNY ZGŁOSZENIA:",
sentKeyNumber2: "KLUCZ AUTORYZACYJNY PRZYPISANY DO ZGŁOSZENIA:",
sentAdditionalInfo: "Informacje dodatkowe",
sentSourceDocumentID: "Numer własny zgłoszenia:",
sentAdresses: "Kanały komunikacji zwrotnej",
sentEmail: "Adresy e-mail",
sentWebservice: "Kanał Web service",
sentWS: "Adres Web service zapisany w usłudze e-Klient:",
sentStatusYes: "Tak",
sentStatusNo: "Nie",
sentURL: "Adres URL:",
sentUserName: "Nazwa użytkownika:",
sentPassword: "Hasło:",
sentAuthenticationKey: "Odcisk palca certyfikatu:",
sentStatements: "Oświadczenia",
sentStatements1: "Posiadam upoważnienie do działania w imieniu podmiotu zobowiązanego do wypełnienia i przesłania zgłoszenia",
sentStatementsFullName: "Imię i nazwisko:"
});

languative.modifyDictionary("en", {
sent400: "SENT400 - VERIFICATION OF KEYS AND DOWNLOADING THE NOTIFICATION OF THE CARRIAGE OF GOODS",
selectLanguage: "Select language:",
english: "English",
polish: "Polski",
sentNumber: "CARRIAGE NOTIFICATION NUMBER:",
sentKeyNumber2: "AUTHORISATION KEY ASSIGNED TO THE NOTIFICATION:",
sentAdditionalInfo: "Additional information",
sentSourceDocumentID: "Own number of the document:",
sentAdresses: "Feedback communication channel",
sentEmail: "E-mail addresses",
sentWebservice: "Web service channel",
sentWS: "Web service address which is indicated in the e-Client service:",
sentStatusYes: "Yes",
sentStatusNo: "No",
sentURL: "URL address:",
sentUserName: "User Name:",
sentPassword: "Password:",
sentAuthenticationKey: "Fingerprint of certificate:",
sentStatements: "Declarations",
sentStatements1: "I am authorized to act on behalf of the entity obliged to fill and send the notification",
sentStatementsFullName: "Full Name:"
});


function loadHtmlDictionary() {
document.getElementById("htmlDictionary").innerText = JSON.stringify(languative.dictonaries.html, null, "  ");
}

function loadActiveDictionary() {
document.getElementById("activeDictionary").innerText = JSON.stringify(languative.getDictionaryFromHtml(), null, "  ");
}


//]]>
                </script>
              <style>
                * {
                -webkit-print-color-adjust: exact !important;
                color-adjust: exact !important;
                }

                @media print {
                body {-webkit-print-color-adjust: exact;}
                }

                body {
                font-family: "Helvetica Neue",Helvetica,Arial,sans-serif;
                margin: 0 auto;
                padding: 0 auto;
                }

                .sent-xslt {
                border-collapse: initial;
                }

                .sent-xslt h1 {
                padding: 6px 4px 4px 10px;
                color:#000000;
                margin-top: 0;
                background-color:#c5c2c2;
                font-weight: normal;
                font-size: 12px;
                margin-bottom: 0;
                border-bottom: 1px solid #c8c9ca;
                }

                .sent-xslt .s1 {
                max-width: 1220px;
                border: 1px solid #c8c9ca;
                }

                .sent-xslt .t1 {
                position: relative;
                display: table;
                width: 100%;
                }

                .sent-xslt .t2 {
                padding: 15px 5px 3px 5px;
                border: 1px solid;
                margin: 0 10px 20px 10px;
                }

                .sent-xslt .t3 {
                padding: 15px 5px 3px 5px;
                border: 1px solid red;
                margin: 0 10px 20px 10px;
                }

                .sent-xslt .grupName {
                font-size: 12px;
                margin: 0 !important;
                font-weight: bold;
                display:block;
                color: #000000;
                background-color:#dbddde;
                padding:5px 5px 5px 10px;
                border-top: 1px solid #dbddde;
                }

                .sent-xslt .grupNameRed {
                font-size: 14px;
                margin: -15px -5px 0 -5px;
                font-weight: bold;
                display:block;
                color: #000000;
                background-color:red;
                padding:5px 5px 5px 10px;
                border: 1px solid red;
                }

                .sent-xslt .element-1 {
                font-size: 12px;
                font-weight: normal;
                }

                .sent-xslt .element-2 {
                font-size: 14px;
                font-weight: normal;
                color: #008540;
                }

                .sent-xslt .green {
                background-color: #DAFFCC;
                height: 35px;
                padding-top: 4px;
                }

                .sent-xslt .green-key {
                background-color: #DAFFCC;
                padding: 7px 0px !important;
                }

                .sent-xslt .element-3 {
                font-family: "Helvetica Neue",Helvetica,Arial,sans-serif;
                font-size: 12px;
                font-weight: normal;
                border-spacing: 10 10;
                white-space: pre-wrap; /* Since CSS 2.1 */
                white-space: -moz-pre-wrap; /* Mozilla, since 1999 */
                white-space: -pre-wrap; /* Opera 4-6 */
                white-space: -o-pre-wrap; /* Opera 7 */
                word-wrap: break-word; /* Internet Explorer 5.5+ */
                word-break: normal;
                }
                
                .sent-xslt .grupInfo p {
                margin: 1px 0 1px 10px;
                font-weight: bold;
                font-size: 12px;
                }

                .sent-xslt .grupInfo {
                border-top: 1px solid #dbddde;
                }

                .sent-xslt .grupInfoSent {
                min-height: 40px;
                }

                .sent-xslt .grupInfoSent p {
                margin: -2px 0 1px 10px;
                font-size: 16px;
                font-weight: bold;
                }

                .sent-xslt .oilstatus {
                margin: 0 5px 0 -5px;
                margin: 2px 0 1px 10px;
                font-size: 14px;
                padding-bottom: 12px;
                color: red;
                }

                .sent-xslt .info {
                width: 100%;
                float: left;
                display: table-cell;
                padding: 4px 0px;
                }

                .sent-xslt .info1 {
                width: 50%;
                float: left;
                display: table-cell;
                padding: 4px 0px;
                }

                .sent-xslt .info3 {
                width: 33%;
                float: left;
                display: table-cell;
                }

                .sent-xslt .lang ul {
                margin: 0 auto;
                padding: 0;
                }

                .sent-xslt .lang ul li {
                display: inline;
                margin-left: 10px;
                }

                .sent-xslt .table {
                display: table;
                width: 99%;
                margin: 4px 0 15px 7px;
                border-spacing: 0 0;
                border-top: 1px solid #999999;
                border-left: 1px solid #999999;
                }

                .sent-xslt .table-header {
                font-size: 10px;
                font-weight: bold;
                padding: 5px;
                background-color: #ececec;
                border-bottom: 1px solid #999999;
                border-right: 1px solid #999999;
                }

                .sent-xslt .table-element {
                font-size: 12px;
                font-weight: normal;
                padding: 2px 5px;
                border-bottom: 1px solid #999999;
                border-right: 1px solid #999999;
                }

                .sent-xslt .table-element2 {
                font-size: 12px;
                font-weight: normal;
                padding: 0;
                }

                .sent-xslt .table-element3 {
                font-size: 12px;
                font-weight: bold;
                border: 1px #999999;
                border-top-style: solid;
                margin: 0;
                }

                .sent-xslt .table-element p {
                margin-left: 0;
                }

                .sent-xslt .table-element2 p {
                margin-left: 0;
                }

                .sent-xslt .table-element3 p {
                margin-left: 0;
                padding: 0px 5px;
                }

              </style>
            </head>
          <body>
            <div class="sent-xslt">
              <section class="sent-xslt s1">
                <div class="sent-xslt lang">
                  <ul>
                    <li>
                      <span class="sent-xslt element-1" data-phrase-id="selectLanguage"></span>
                    </li>
                    <li>
                      <span class="sent-xslt element-1">
                        <a href="#" onclick="languative.changeLanguage('en');">
                          <img src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAALCAIAAAD5gJpuAAAB6ElEQVQoz2OYNHPfjqtvqqcfS2kGosOJjQdu3n27NrlxTUIdkOGZvc0jbYdtzIaoxp1zAvOr5x5lWLLi1P+Nq/79+3/74ZdFG27PX38HyP4/ped/XyuQMWnh5d65F06eePyvq+bf358TNl1gSGo5uOfku/9Ll/8/uPf///9t064Cyf+pmf8TEoF0Sd+lL4vWfO/uBrLnrbokaTIDpGHhhrt1E68+3Hf/T1P9fwiIifkfHgFi5Gb+f/Hiwp23jp7Li5qOCOpOZAA6FOQGNBAa+t/PD00MqOzMtZcMaxJr/0/u+J+S8j8+/n9k5P+QEJBSH59/rq6/7O1/Wlp+NzH5qqf3VVv7Z7Bbq7wVDhtsbf+YWUDMBeK/f//++fvn958/J6++YLCP29Qz53xU2o4rV9//f/vmZ3I8SJWRyW99Q7CGv0+dHPfP3CohPSskYT2DcDaDedi6xetBIfO5se5DV1dMyTEg+4+27i9NbaCrreyX/Pz//8usuS8SYpqmnmMQTGeYvPnyv39/v7dXHD1wu7DhYF7DYaAL/4Z4/A5y/vf3b3jattC41dsP3/r758frBN/soiUMVfMOTHFJds5cJKgzh0djMofqhPPXXrRKW7SIm5y+8pJBvJhBtIBBOFfEsK53z3VX0zwAPExoqi63l4YAAAAASUVORK5CYII='/>
                        </a>
                      </span>
                    </li>
                    <li>
                      <span class="sent-xslt element-1">
                        <a href="#" onclick="languative.changeLanguage('pl');">
                          <img src='data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAALCAMAAABBPP0LAAAAhFBMVEXDAADKAADVAQHX19faAADd3d3jDQ3k5eXlExPmGRnnLi7oHx/oMjLoNjbpJCTqKirq6urrLi7sLy/sOzrsRETtNDTtS0vuUFDu7u7vi4vvmZnwVlfwj4/xlJTy8vL0m5v19fX29vb39/f4+Pj5+fn6+vr7+/v8/Pz9/f39/f7+/v7///9BfFeGAAAAXUlEQVQIHQXB0W1CMRRAMecRpI7BZ/dfiRWQqBC5p/Z6wPDhz5t1+xWVqp4bq1FVLRuWqioucKuqNPu8AKNjtb3AdU5nuncB1zmdSTa4vtOZxrT94Hsf+TQstkEQ/8uqTs/uhVeSAAAAAElFTkSuQmCC'/>
                        </a>
                      </span>
                    </li>
                  </ul>
                </div>
                <h1 data-phrase-id="sent400"></h1>
                <div class="sent-xslt t1">
                  <div class="sent-xslt grupInfoSent">
                    <div class="sent-xslt info1">
                      <p>
                        <span class="sent-xslt element-1 sent" data-phrase-id="sentNumber"></span>
                        <br/>
                        <xsl:value-of select="ns1:SentNumber"/>
                      </p>
                    </div>
                    <div class="sent-xslt info1 green-key">
                      <p>
                        <span class="sent-xslt element-1 sent" data-phrase-id="sentKeyNumber2"></span>
                        <br/>
                        <xsl:value-of select="ns1:KeyNumber"/>
                      </p>
                    </div>
                  </div>
                </div>
                <xsl:if test="ns1:DocumentId != ''">
                  <div class="sent-xslt t1">
                    <p class="sent-xslt grupName" data-phrase-id="sentAdditionalInfo"></p>
                    <div class="sent-xslt t1">
                      <div class="sent-xslt grupInfo">
                        <div class="sent-xslt info">
                          <p>
                            <span class="sent-xslt element-1" data-phrase-id="sentSourceDocumentID"></span>
                            <xsl:value-of select="ns1:DocumentId"/>
                          </p>
                        </div>
                      </div>
                    </div>
                  </div>
                </xsl:if>
                <xsl:if test="ns1:ResponseAddress != ''">
                  <div class="sent-xslt t1">
                    <p class="sent-xslt grupName" data-phrase-id="sentAdresses"></p>
                    <div class="sent-xslt grupInfo">
                      <xsl:if test="ns1:ResponseAddress/tp:EmailChannel != ''">
                        <div class="sent-xslt info1">
                          <p>
                            <span class="sent-xslt element-2" data-phrase-id="sentEmail"></span>
                          </p>
                          <xsl:if test="ns1:ResponseAddress/tp:EmailChannel/tp:EmailAddress1 != ''">
                            <p>
                              <xsl:value-of select="ns1:ResponseAddress/tp:EmailChannel/tp:EmailAddress1"/>
                            </p>
                          </xsl:if>
                          <xsl:if test="ns1:ResponseAddress/tp:EmailChannel/tp:EmailAddress2 != ''">
                            <p>
                              <xsl:value-of select="ns1:ResponseAddress/tp:EmailChannel/tp:EmailAddress2"/>
                            </p>
                          </xsl:if>
                          <xsl:if test="ns1:ResponseAddress/tp:EmailChannel/tp:EmailAddress3 != ''">
                            <p>
                              <xsl:value-of select="ns1:ResponseAddress/tp:EmailChannel/tp:EmailAddress3"/>
                            </p>
                          </xsl:if>
                        </div>
                      </xsl:if>
                      <xsl:if test="ns1:ResponseAddress/tp:WebServiceChannel != ''">
                        <div class="sent-xslt info1">
                          <p>
                            <span class="sent-xslt element-2" data-phrase-id="sentWebservice"></span>
                          </p>
                          <p>
                            <span class="sent-xslt element-1" data-phrase-id="sentWS"></span>
                            <span>
                              <xsl:choose>
                                <xsl:when test="ns1:ResponseAddress/tp:WebServiceChannel/tp:WsFromSISC = 'true'">
                                  <span data-phrase-id="sentStatusYes"></span>
                                </xsl:when>
                                <xsl:when test="ns1:ResponseAddress/tp:WebServiceChannel/tp:WsFromSISC = 'false'">
                                  <span data-phrase-id="sentStatusNo"></span>
                                </xsl:when>
                              </xsl:choose>
                            </span>
                          </p>
                          <xsl:if test="ns1:ResponseAddress/tp:WebServiceChannel/tp:UrlAddress != ''">
                            <p>
                              <span class="sent-xslt element-1" data-phrase-id="sentURL"></span>
                              <xsl:value-of select="ns1:ResponseAddress/tp:WebServiceChannel/tp:UrlAddress"/>
                            </p>
                          </xsl:if>
                          <xsl:if test="ns1:ResponseAddress/tp:WebServiceChannel/tp:Username != ''">
                            <p>
                              <span class="sent-xslt element-1" data-phrase-id="sentUserName"></span>
                              <xsl:value-of select="ns1:ResponseAddress/tp:WebServiceChannel/tp:Username"/>
                            </p>
                          </xsl:if>
                          <xsl:if test="ns1:ResponseAddress/tp:WebServiceChannel/tp:UserPassword != ''">
                            <p>
                              <span class="sent-xslt element-1" data-phrase-id="sentPassword"></span>
                              <xsl:value-of select="ns1:ResponseAddress/tp:WebServiceChannel/tp:UserPassword"/>
                            </p>
                          </xsl:if>
                          <xsl:if test="ns1:ResponseAddress/tp:WebServiceChannel/tp:AuthenticationKey != ''">
                            <p>
                              <span class="sent-xslt element-1" data-phrase-id="sentAuthenticationKey"></span>
                              <xsl:value-of select="ns1:ResponseAddress/tp:WebServiceChannel/tp:AuthenticationKey"/>
                            </p>
                          </xsl:if>
                        </div>
                      </xsl:if>
                    </div>
                  </div>
                </xsl:if>
                <div class="sent-xslt t1">
                  <p class="sent-xslt grupName" data-phrase-id="sentStatements"></p>
                  <div class="sent-xslt grupInfo">
                    <p>
                      <xsl:choose>
                        <xsl:when test="ns1:Statements/tp:Statement1 = 'true'">
                          <input type="checkbox" onclick="return false;" checked=""/>
                          <span class="sent-xslt element-1" data-phrase-id="sentStatements1"></span>
                        </xsl:when>
                        <xsl:when test="ns1:Statements/tp:Statement1 = 'false'">
                          <input type="checkbox" onclick="return false;"/>
                          <span class="sent-xslt element-1" data-phrase-id="sentStatements1"></span>
                        </xsl:when>
                      </xsl:choose>
                    </p>
                    <p style="padding: 5px">
                      <span class="sent-xslt element-1" data-phrase-id="sentStatementsFullName"></span>
                      <xsl:value-of select="ns1:Statements/tp:FirstName"/>&#160;<xsl:value-of select="ns1:Statements/tp:LastName"/>
                    </p>
                  </div>
                </div>
              </section>
            </div>
          </body>
        </html>
    </xsl:template>
</xsl:stylesheet>
